/**
 * إدارة الشريط المتحرك
 * يقوم هذا الملف بإنشاء وإدارة الشريط المتحرك للدول وأسعار الشحن
 */

// تهيئة الشريط المتحرك عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
  // تحميل بيانات الدول
  loadCountriesForTicker();

  // توليد بيانات أسعار الشحن
  generateShippingRates();

  // تهيئة الأشرطة المتحركة
  initCountriesTicker();
  initShippingRatesTicker();
});

// استخدام بيانات الدول من ملف countries-data.js
let countriesTickerData = [];

// تحميل بيانات جميع دول العالم للشريط المتحرك
function loadCountriesForTicker() {
  // التأكد من وجود بيانات الدول
  if (typeof countriesData !== 'undefined' && Array.isArray(countriesData)) {
    // تحويل بيانات الدول إلى التنسيق المطلوب للشريط المتحرك
    countriesTickerData = countriesData.map(country => {
      return {
        code: country.code,
        name: country.name,
        flag: `https://flagcdn.com/w80/${country.code.toLowerCase()}.png`
      };
    });
  } else {
    // في حالة عدم وجود بيانات الدول، استخدام بيانات افتراضية
    countriesTickerData = [
      {
        code: "CN",
        name: "الصين",
        flag: "https://flagcdn.com/w80/cn.png"
      },
      {
        code: "YE",
        name: "اليمن",
        flag: "https://flagcdn.com/w80/ye.png"
      },
      {
        code: "OM",
        name: "عمان",
        flag: "https://flagcdn.com/w80/om.png"
      },
      {
        code: "SA",
        name: "السعودية",
        flag: "https://flagcdn.com/w80/sa.png"
      },
      {
        code: "AE",
        name: "الإمارات",
        flag: "https://flagcdn.com/w80/ae.png"
      },
      {
        code: "KW",
        name: "الكويت",
        flag: "https://flagcdn.com/w80/kw.png"
      },
      {
        code: "QA",
        name: "قطر",
        flag: "https://flagcdn.com/w80/qa.png"
      },
      {
        code: "BH",
        name: "البحرين",
        flag: "https://flagcdn.com/w80/bh.png"
      },
      {
        code: "JO",
        name: "الأردن",
        flag: "https://flagcdn.com/w80/jo.png"
      },
      {
        code: "EG",
        name: "مصر",
        flag: "https://flagcdn.com/w80/eg.png"
      },
      {
        code: "IQ",
        name: "العراق",
        flag: "https://flagcdn.com/w80/iq.png"
      },
      {
        code: "LB",
        name: "لبنان",
        flag: "https://flagcdn.com/w80/lb.png"
      },
      {
        code: "SY",
        name: "سوريا",
        flag: "https://flagcdn.com/w80/sy.png"
      },
      {
        code: "PS",
        name: "فلسطين",
        flag: "https://flagcdn.com/w80/ps.png"
      },
      {
        code: "TR",
        name: "تركيا",
        flag: "https://flagcdn.com/w80/tr.png"
      },
      {
        code: "IR",
        name: "إيران",
        flag: "https://flagcdn.com/w80/ir.png"
      },
      {
        code: "MY",
        name: "ماليزيا",
        flag: "https://flagcdn.com/w80/my.png"
      },
      {
        code: "ID",
        name: "إندونيسيا",
        flag: "https://flagcdn.com/w80/id.png"
      },
      {
        code: "TH",
        name: "تايلاند",
        flag: "https://flagcdn.com/w80/th.png"
      },
      {
        code: "SG",
        name: "سنغافورة",
        flag: "https://flagcdn.com/w80/sg.png"
      }
    ];
  }
}

// بيانات أسعار الشحن
let shippingRatesData = [];

// توليد بيانات أسعار الشحن لجميع الدول
function generateShippingRates() {
  // التأكد من وجود بيانات الدول
  if (countriesTickerData.length === 0) {
    // استخدام بيانات افتراضية إذا لم تكن هناك بيانات دول
    shippingRatesData = [
      {
        route: "الصين - اليمن",
        price: 25,
        unit: "دولار / كجم",
        icon: "fa-plane"
      },
      {
        route: "الصين - السعودية",
        price: 22,
        unit: "دولار / كجم",
        icon: "fa-plane"
      },
      {
        route: "اليمن - عمان",
        price: 15,
        unit: "دولار / كجم",
        icon: "fa-ship"
      },
      {
        route: "السعودية - اليمن",
        price: 10,
        unit: "دولار / كجم",
        icon: "fa-truck"
      },
      {
        route: "الإمارات - اليمن",
        price: 18,
        unit: "دولار / كجم",
        icon: "fa-plane"
      },
      {
        route: "الكويت - اليمن",
        price: 20,
        unit: "دولار / كجم",
        icon: "fa-plane"
      },
      {
        route: "قطر - اليمن",
        price: 19,
        unit: "دولار / كجم",
        icon: "fa-plane"
      },
      {
        route: "البحرين - اليمن",
        price: 17,
        unit: "دولار / كجم",
        icon: "fa-ship"
      },
      {
        route: "مصر - اليمن",
        price: 16,
        unit: "دولار / كجم",
        icon: "fa-ship"
      },
      {
        route: "تركيا - اليمن",
        price: 23,
        unit: "دولار / كجم",
        icon: "fa-plane"
      }
    ];
    return;
  }

  // إنشاء قائمة بالدول الرئيسية للشحن
  const mainShippingCountries = ["YE", "SA", "OM", "AE", "CN"];

  // توليد أسعار الشحن لجميع الدول
  shippingRatesData = [];

  // إضافة مسارات الشحن من الدول الرئيسية إلى جميع الدول
  countriesTickerData.forEach(destCountry => {
    // تجاهل الدول الرئيسية كوجهات (لتجنب التكرار)
    if (!mainShippingCountries.includes(destCountry.code)) {
      // اختيار دولة رئيسية عشوائية كمصدر
      const sourceIndex = Math.floor(Math.random() * mainShippingCountries.length);
      const sourceCode = mainShippingCountries[sourceIndex];
      const sourceCountry = countriesTickerData.find(c => c.code === sourceCode);

      if (sourceCountry) {
        // توليد سعر عشوائي بين 10 و 35
        const price = Math.floor(Math.random() * 25) + 10;

        // اختيار وسيلة نقل عشوائية
        const transportIcons = ["fa-plane", "fa-ship", "fa-truck"];
        const iconIndex = Math.floor(Math.random() * transportIcons.length);

        // إضافة مسار الشحن
        shippingRatesData.push({
          route: `${sourceCountry.name} - ${destCountry.name}`,
          price: price,
          unit: "دولار / كجم",
          icon: transportIcons[iconIndex]
        });
      }
    }
  });

  // إضافة المسارات الثابتة المهمة
  const fixedRoutes = [
    {
      route: "الصين - اليمن",
      price: 25,
      unit: "دولار / كجم",
      icon: "fa-plane"
    },
    {
      route: "الصين - السعودية",
      price: 22,
      unit: "دولار / كجم",
      icon: "fa-plane"
    },
    {
      route: "اليمن - عمان",
      price: 15,
      unit: "دولار / كجم",
      icon: "fa-ship"
    },
    {
      route: "السعودية - اليمن",
      price: 10,
      unit: "دولار / كجم",
      icon: "fa-truck"
    },
    {
      route: "الإمارات - اليمن",
      price: 18,
      unit: "دولار / كجم",
      icon: "fa-plane"
    }
  ];

  // دمج المسارات الثابتة مع المسارات المولدة
  shippingRatesData = [...fixedRoutes, ...shippingRatesData];

  // الحد من عدد المسارات المعروضة لتحسين الأداء (اختياري)
  if (shippingRatesData.length > 50) {
    shippingRatesData = shippingRatesData.slice(0, 50);
  }
}

// تهيئة شريط الدول المتحرك
function initCountriesTicker() {
  const tickerContainer = document.getElementById('countriesTickerContainer');
  if (!tickerContainer) return;

  // إنشاء عنوان الشريط
  const tickerTitle = document.createElement('div');
  tickerTitle.className = 'ticker-title';
  tickerTitle.textContent = 'الدول المتاحة للشحن';
  tickerContainer.appendChild(tickerTitle);

  // إنشاء الشريط المتحرك
  const ticker = document.createElement('div');
  ticker.className = 'ticker';

  // إضافة عناصر الدول
  countriesTickerData.forEach(country => {
    const tickerItem = document.createElement('div');
    tickerItem.className = 'ticker-item';

    // إضافة علم الدولة
    const flag = document.createElement('img');
    flag.className = 'country-flag';
    flag.src = country.flag;
    flag.alt = `علم ${country.name}`;

    // إضافة اسم الدولة
    const name = document.createElement('div');
    name.className = 'country-name';
    name.textContent = country.name;

    // إضافة العناصر إلى عنصر الشريط
    tickerItem.appendChild(flag);
    tickerItem.appendChild(name);

    // إضافة عنصر الشريط إلى الشريط
    ticker.appendChild(tickerItem);
  });

  // إضافة الشريط إلى الحاوية
  tickerContainer.appendChild(ticker);

  // تكرار العناصر لضمان استمرارية الحركة
  const tickerClone = ticker.cloneNode(true);
  tickerContainer.appendChild(tickerClone);
}

// تهيئة شريط أسعار الشحن المتحرك
function initShippingRatesTicker() {
  const ratesContainer = document.getElementById('shippingRatesContainer');
  if (!ratesContainer) return;

  // إنشاء عنوان الشريط
  const ratesTitle = document.createElement('div');
  ratesTitle.className = 'shipping-rates-title';
  ratesTitle.textContent = 'أسعار الشحن';
  ratesContainer.appendChild(ratesTitle);

  // إنشاء الشريط المتحرك
  const rates = document.createElement('div');
  rates.className = 'shipping-rates';

  // إضافة عناصر أسعار الشحن
  shippingRatesData.forEach(rate => {
    const rateItem = document.createElement('div');
    rateItem.className = 'rate-item';

    // إضافة أيقونة وسيلة النقل
    const icon = document.createElement('i');
    icon.className = `fas ${rate.icon} transport-icon`;

    // إضافة اسم المسار
    const route = document.createElement('div');
    route.className = 'route-name';
    route.textContent = rate.route;

    // إضافة سعر الشحن
    const price = document.createElement('div');
    price.className = 'shipping-price';
    price.textContent = rate.price;

    // إضافة وحدة السعر
    const unit = document.createElement('div');
    unit.className = 'price-unit';
    unit.textContent = rate.unit;

    // إضافة العناصر إلى عنصر السعر
    rateItem.appendChild(icon);
    rateItem.appendChild(route);
    rateItem.appendChild(price);
    rateItem.appendChild(unit);

    // إضافة عنصر السعر إلى الشريط
    rates.appendChild(rateItem);
  });

  // إضافة الشريط إلى الحاوية
  ratesContainer.appendChild(rates);

  // تكرار العناصر لضمان استمرارية الحركة
  const ratesClone = rates.cloneNode(true);
  ratesContainer.appendChild(ratesClone);
}
