/**
 * تأثيرات صفحة تسجيل الدخول البنفسجية
 * يتضمن تأثيرات الدوائر المتحركة والتفاعلات
 */

document.addEventListener('DOMContentLoaded', function() {
    // ===== تأثيرات الحقول =====
    initializeInputEffects();

    // ===== تأثيرات ظهور العناصر =====
    animateElements();

    // ===== تأثير الزر =====
    initializeButtonEffects();

    // ===== إضافة قطرات الماء =====
    createWaterDrops();

    // ===== تحسين تأثيرات الأمواج =====
    enhanceWaveEffects();
});

/**
 * إنشاء قطرات الماء
 */
function createWaterDrops() {
    const body = document.querySelector('body');
    const dropCount = 20;

    // إنشاء قطرات الماء
    for (let i = 0; i < dropCount; i++) {
        setTimeout(() => {
            const drop = document.createElement('div');
            drop.classList.add('water-drop');

            // تعيين موقع عشوائي
            const posX = Math.random() * 100;
            drop.style.left = `${posX}%`;

            // تعيين حجم عشوائي
            const size = Math.random() * 5 + 5;
            drop.style.width = `${size}px`;
            drop.style.height = `${size}px`;

            // تعيين مدة عشوائية للحركة
            const duration = Math.random() * 3 + 2;
            drop.style.animationDuration = `${duration}s`;

            // إضافة القطرة إلى الصفحة
            body.appendChild(drop);

            // إزالة القطرة بعد انتهاء التأثير
            setTimeout(() => {
                drop.remove();
            }, duration * 1000);
        }, i * 300); // إنشاء قطرة كل 300 مللي ثانية
    }

    // إنشاء قطرات جديدة كل 6 ثواني
    setInterval(createWaterDrops, 6000);
}

/**
 * تهيئة تأثيرات الحقول (تم تبسيطها)
 */
function initializeInputEffects() {
    const inputs = document.querySelectorAll('.login-input');
    const branchSelect = document.getElementById('branch_id');
    const branchHint = document.querySelector('.branch-hint');

    inputs.forEach(input => {
        // تأثير التركيز
        input.addEventListener('focus', function() {
            // تحريك الأيقونة فقط
            const icon = this.nextElementSibling;
            if (icon) {
                icon.style.color = 'var(--accent-color)';
            }
        });

        // إزالة تأثير التركيز
        input.addEventListener('blur', function() {
            // إعادة الأيقونة
            const icon = this.nextElementSibling;
            if (icon) {
                icon.style.color = 'rgba(255, 255, 255, 0.6)';
            }
        });
    });

    // تأثيرات خاصة باختيار الفرع
    if (branchSelect) {
        branchSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const branchName = selectedOption.textContent.trim();

            // تحديث نص التلميح
            if (branchHint) {
                branchHint.innerHTML = `تم اختيار <strong>${branchName}</strong>. سيتم عرض البيانات الخاصة بهذا الفرع.`;
                branchHint.style.color = 'rgba(255, 255, 255, 0.9)';

                // تأثير وميض
                branchHint.style.animation = 'none';
                setTimeout(() => {
                    branchHint.style.animation = 'pulse 1.5s ease-in-out';
                }, 10);
            }

            // تأثير على الأيقونة
            const icon = this.nextElementSibling;
            if (icon) {
                icon.style.color = 'var(--accent-color)';
                icon.style.transform = 'scale(1.2)';
                setTimeout(() => {
                    icon.style.transform = 'scale(1)';
                }, 300);
            }
        });
    }
}

/**
 * تحريك العناصر عند تحميل الصفحة
 */
function animateElements() {
    const loginCard = document.querySelector('.login-card');
    const logo = document.querySelector('.logo-image');
    const title = document.querySelector('.login-title');
    const inputGroups = document.querySelectorAll('.input-group');
    const rememberMe = document.querySelector('.remember-me');
    const button = document.querySelector('.login-button');

    // تأثير ظهور البطاقة
    if (loginCard) {
        loginCard.style.opacity = '0';
        loginCard.style.transform = 'translateY(20px)';

        setTimeout(() => {
            loginCard.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
            loginCard.style.opacity = '1';
            loginCard.style.transform = 'translateY(0)';
        }, 100);
    }

    // تأثير ظهور الشعار
    if (logo) {
        logo.style.opacity = '0';
        logo.style.transform = 'scale(0.8)';

        setTimeout(() => {
            logo.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            logo.style.opacity = '1';
            logo.style.transform = 'scale(1)';
        }, 400);
    }

    // تأثير ظهور العنوان
    if (title) {
        title.style.opacity = '0';
        title.style.transform = 'translateY(-10px)';

        setTimeout(() => {
            title.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            title.style.opacity = '1';
            title.style.transform = 'translateY(0)';
        }, 600);
    }

    // تأثير ظهور الحقول
    inputGroups.forEach((group, index) => {
        group.style.opacity = '0';
        group.style.transform = 'translateX(10px)';

        setTimeout(() => {
            group.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            group.style.opacity = '1';
            group.style.transform = 'translateX(0)';
        }, 800 + (index * 150));
    });

    // تأثير ظهور التذكر
    if (rememberMe) {
        rememberMe.style.opacity = '0';

        setTimeout(() => {
            rememberMe.style.transition = 'opacity 0.5s ease';
            rememberMe.style.opacity = '1';
        }, 1200);
    }

    // تأثير ظهور الزر
    if (button) {
        button.style.opacity = '0';
        button.style.transform = 'translateY(10px)';

        setTimeout(() => {
            button.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            button.style.opacity = '1';
            button.style.transform = 'translateY(0)';

            // تأثير نبض للزر
            setTimeout(() => {
                button.style.transform = 'scale(1.05)';
                button.style.boxShadow = '0 8px 25px rgba(182, 109, 255, 0.4)';

                setTimeout(() => {
                    button.style.transform = 'scale(1)';
                    button.style.boxShadow = '0 5px 15px rgba(182, 109, 255, 0.3)';
                }, 300);
            }, 500);
        }, 1400);
    }
}

/**
 * تهيئة تأثيرات الزر
 */
function initializeButtonEffects() {
    const button = document.querySelector('.login-button');
    if (!button) return;

    // تأثير التحويم
    button.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-3px) scale(1.01)';
        this.style.boxShadow = '0 10px 25px rgba(26, 75, 124, 0.5), 0 0 0 5px rgba(95, 184, 255, 0.2), inset 0 0 0 0.5px rgba(255, 255, 255, 0.4)';

        // تأثير إضافي للأيقونة
        const icon = this.querySelector('.button-icon');
        if (icon) {
            icon.style.transform = 'translateX(-3px) scale(1.2)';
            icon.style.filter = 'drop-shadow(0 2px 4px rgba(0, 0, 0, 0.4))';
        }
    });

    button.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0) scale(1)';
        this.style.boxShadow = '0 5px 15px rgba(26, 75, 124, 0.4), 0 0 0 0 rgba(95, 184, 255, 0.5), inset 0 0 0 0.5px rgba(255, 255, 255, 0.2)';

        // إعادة الأيقونة
        const icon = this.querySelector('.button-icon');
        if (icon) {
            icon.style.transform = '';
            icon.style.filter = '';
        }
    });

    // تأثير النقر
    button.addEventListener('click', function(e) {
        // إنشاء تأثير التموج
        const ripple = document.createElement('span');
        ripple.classList.add('ripple');
        this.appendChild(ripple);

        // تحديد موقع النقر
        const rect = button.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;

        // تعيين موقع وحجم التموج
        ripple.style.left = `${x}px`;
        ripple.style.top = `${y}px`;

        // تأثير الضغط
        this.style.transform = 'translateY(0) scale(0.98)';
        this.style.boxShadow = '0 3px 10px rgba(26, 75, 124, 0.4), 0 0 0 2px rgba(95, 184, 255, 0.1), inset 0 0 0 0.5px rgba(255, 255, 255, 0.2)';

        // إزالة عنصر التموج بعد انتهاء التأثير
        setTimeout(() => {
            ripple.remove();
            this.style.transform = 'translateY(0) scale(1)';
            this.style.boxShadow = '0 5px 15px rgba(26, 75, 124, 0.4), 0 0 0 0 rgba(95, 184, 255, 0.5), inset 0 0 0 0.5px rgba(255, 255, 255, 0.2)';
        }, 800);
    });
}

/**
 * تحسين تأثيرات الأمواج - تصميم احترافي
 */
function enhanceWaveEffects() {
    const ocean = document.querySelector('.ocean');
    if (!ocean) return;

    // إضافة تأثيرات متقدمة للأمواج
    const waves = ocean.querySelectorAll('.wave');

    // إضافة تأثير الانعكاس للمحيط
    const reflection = document.createElement('div');
    reflection.classList.add('ocean-reflection');
    reflection.style.position = 'absolute';
    reflection.style.bottom = '0';
    reflection.style.left = '0';
    reflection.style.width = '100%';
    reflection.style.height = '100%';
    reflection.style.background = 'linear-gradient(to bottom, rgba(255,255,255,0.1), rgba(255,255,255,0))';
    reflection.style.opacity = '0.3';
    reflection.style.zIndex = '-1';
    reflection.style.pointerEvents = 'none';
    reflection.style.animation = 'reflection-fade 8s ease-in-out infinite alternate';

    // إضافة تأثير الانعكاس للمحيط
    const style = document.createElement('style');
    style.textContent = `
        @keyframes reflection-fade {
            0%, 100% { opacity: 0.2; transform: scale(1); }
            50% { opacity: 0.4; transform: scale(1.05); }
        }

        @keyframes bubble-rise {
            0% { transform: translateY(0) scale(0.5); opacity: 0.7; }
            100% { transform: translateY(-100px) scale(1.2); opacity: 0; }
        }

        .ocean-bubble {
            position: absolute;
            border-radius: 50%;
            background: radial-gradient(circle at 30% 30%, rgba(255,255,255,0.8), rgba(255,255,255,0.3));
            box-shadow: 0 0 5px rgba(255,255,255,0.5);
            pointer-events: none;
            z-index: 5;
        }
    `;
    document.head.appendChild(style);
    ocean.appendChild(reflection);

    // تحسين تأثيرات الأمواج
    waves.forEach((wave, index) => {
        // تعيين سرعات مختلفة للأمواج - أبطأ وأكثر طبيعية
        const baseSpeed = 20 - (index * 2); // الموجة الأولى أبطأ
        const direction = index % 2 === 0 ? 'normal' : 'reverse';
        const delay = index * 0.8;

        // تطبيق منحنى بيزييه أكثر طبيعية
        const easing = 'cubic-bezier(0.36, 0.45, 0.63, 0.53)';

        wave.style.animationTimingFunction = easing;
        wave.style.animationDuration = `${baseSpeed}s`;
        wave.style.animationDirection = direction;
        wave.style.animationDelay = `${delay}s`;

        // تعيين ارتفاعات مختلفة للأمواج
        const height = 120 - (index * 20);
        wave.style.height = `${height}px`;

        // تعيين شفافية مختلفة للأمواج
        const opacity = 0.9 - (index * 0.15);
        wave.style.opacity = opacity;

        // تعيين مقياس مختلف للأمواج
        const scale = 1 + (index * 0.05);

        // إضافة تأثير التموج المتدرج
        const blurAmount = index * 1;
        const brightness = 1 - (index * 0.1);
        wave.style.filter = `blur(${blurAmount}px) brightness(${brightness})`;

        // إضافة تأثير العمق ثلاثي الأبعاد
        wave.style.transform = `scaleX(${scale}) translateZ(${index * -10}px)`;
    });

    // إضافة تأثير التفاعل مع حركة الماوس - أكثر نعومة وواقعية
    let mouseX = 0;
    let mouseY = 0;
    let targetX = 0;
    let targetY = 0;

    document.addEventListener('mousemove', function(e) {
        // تحديث الموقع المستهدف
        targetX = (e.clientX / window.innerWidth) - 0.5;
        targetY = (e.clientY / window.innerHeight) - 0.5;
    });

    // تحديث موقع الأمواج بشكل متواصل للحصول على حركة أكثر نعومة
    function updateWaves() {
        // تحريك الموقع الحالي نحو الموقع المستهدف بشكل تدريجي
        mouseX += (targetX - mouseX) * 0.05;
        mouseY += (targetY - mouseY) * 0.05;

        waves.forEach((wave, index) => {
            const waveIndex = index + 1;
            const offsetX = waveIndex * 10 * mouseX;
            const offsetY = waveIndex * 5 * mouseY;
            const rotateZ = waveIndex * 2 * mouseX; // إضافة دوران خفيف
            const scale = 1 + (index * 0.05);

            // تطبيق التحويلات مع الحفاظ على تأثير العمق
            wave.style.transform = `scaleX(${scale}) translateX(${offsetX}px) translateY(${offsetY}px) translateZ(${index * -10}px) rotateZ(${rotateZ}deg)`;
        });

        // إضافة فقاعات عشوائية
        if (Math.random() < 0.03) { // 3% فرصة في كل إطار
            createBubble();
        }

        requestAnimationFrame(updateWaves);
    }

    // إنشاء فقاعات ماء متحركة
    function createBubble() {
        const bubble = document.createElement('div');
        bubble.classList.add('ocean-bubble');

        // حجم عشوائي
        const size = Math.random() * 10 + 5;
        bubble.style.width = `${size}px`;
        bubble.style.height = `${size}px`;

        // موقع عشوائي في أسفل المحيط
        const posX = Math.random() * 100;
        bubble.style.left = `${posX}%`;
        bubble.style.bottom = '0';

        // مدة عشوائية للحركة
        const duration = Math.random() * 3 + 2;
        bubble.style.animation = `bubble-rise ${duration}s ease-out forwards`;

        // إضافة الفقاعة إلى المحيط
        ocean.appendChild(bubble);

        // إزالة الفقاعة بعد انتهاء التأثير
        setTimeout(() => {
            bubble.remove();
        }, duration * 1000);
    }

    // بدء تحديث الأمواج
    updateWaves();
}
