/**
 * تأثيرات صفحة تسجيل الدخول المميزة
 *
 * @version 2.0
 * @author System Developer
 */

document.addEventListener('DOMContentLoaded', function() {
  // إضافة تأثير الجسيمات المتحركة
  createParticles();

  // إضافة تأثير الخطوط الذهبية
  createGoldLines();

  // إضافة تأثير التموج للزر
  addRippleEffect();

  // إضافة تأثير التركيز على حقول الإدخال
  enhanceInputFields();

  // إضافة تأثير الظهور التدريجي للعناصر
  animateElements();
});

/**
 * إنشاء جسيمات متحركة في الخلفية
 */
function createParticles() {
  const particles = document.querySelector('.particles');
  if (!particles) return;

  // إنشاء الجسيمات
  for (let i = 0; i < 30; i++) {
    const particle = document.createElement('div');
    particle.classList.add('particle');

    // تعيين حجم عشوائي
    const size = Math.random() * 15 + 5;
    particle.style.width = `${size}px`;
    particle.style.height = `${size}px`;

    // تعيين موقع عشوائي
    particle.style.top = `${Math.random() * 100}%`;
    particle.style.left = `${Math.random() * 100}%`;

    // تعيين تأخير عشوائي للحركة
    particle.style.animationDelay = `${Math.random() * 15}s`;

    // تعيين مدة عشوائية للحركة
    particle.style.animationDuration = `${Math.random() * 15 + 10}s`;

    // إضافة الجسيم إلى الحاوية
    particles.appendChild(particle);
  }
}

/**
 * إنشاء خطوط ذهبية متحركة في الخلفية
 */
function createGoldLines() {
  const goldLines = document.querySelector('.gold-lines');
  if (!goldLines) return;

  // إنشاء الخطوط
  for (let i = 0; i < 5; i++) {
    const line = document.createElement('div');
    line.classList.add('gold-line');

    // تعيين موقع عشوائي
    line.style.top = `${i * 20 + Math.random() * 10}%`;

    // تعيين تأخير عشوائي للحركة
    line.style.animationDelay = `${i * 3}s`;

    // تعيين مدة عشوائية للحركة
    line.style.animationDuration = `${Math.random() * 10 + 15}s`;

    // إضافة الخط إلى الحاوية
    goldLines.appendChild(line);
  }
}

/**
 * إضافة تأثير التموج للزر
 */
function addRippleEffect() {
  const buttons = document.querySelectorAll('.login-button');

  buttons.forEach(button => {
    button.addEventListener('click', function(e) {
      const rect = button.getBoundingClientRect();
      const x = e.clientX - rect.left;
      const y = e.clientY - rect.top;

      const ripple = document.createElement('span');
      ripple.classList.add('ripple');
      ripple.style.left = `${x}px`;
      ripple.style.top = `${y}px`;

      button.appendChild(ripple);

      // إزالة عنصر التموج بعد انتهاء التأثير
      setTimeout(() => {
        ripple.remove();
      }, 800);
    });
  });
}

/**
 * تحسين تأثيرات حقول الإدخال
 */
function enhanceInputFields() {
  const inputs = document.querySelectorAll('.login-input');

  inputs.forEach(input => {
    // تأثير التركيز
    input.addEventListener('focus', function() {
      this.parentElement.classList.add('focused');
    });

    input.addEventListener('blur', function() {
      this.parentElement.classList.remove('focused');
    });

    // تأثير التحقق من الإدخال
    input.addEventListener('input', function() {
      if (this.value.trim() !== '') {
        this.classList.add('has-value');
      } else {
        this.classList.remove('has-value');
      }
    });
  });
}

/**
 * تحريك العناصر بتأثير الظهور التدريجي
 */
function animateElements() {
  // تأثير ظهور الشعار
  const logo = document.querySelector('.company-logo');
  if (logo) {
    setTimeout(() => {
      logo.classList.add('visible');
    }, 150);
  }

  // تأثير ظهور العنوان
  const title = document.querySelector('.login-title');
  if (title) {
    setTimeout(() => {
      title.classList.add('visible');
    }, 300);
  }

  // تأثير ظهور حقول الإدخال
  const inputGroups = document.querySelectorAll('.input-group');
  inputGroups.forEach((group, index) => {
    setTimeout(() => {
      group.classList.add('visible');
    }, 450 + (index * 150));
  });

  // تأثير ظهور الزر
  const button = document.querySelector('.login-button');
  if (button) {
    setTimeout(() => {
      button.classList.add('visible');
    }, 900);
  }

  // إضافة تأثير تفاعلي للشعار
  const logoImage = document.querySelector('.logo-image');
  if (logoImage) {
    logoImage.addEventListener('mouseenter', function() {
      this.style.transform = 'scale(1.05)';
      this.style.filter = 'drop-shadow(0 10px 25px rgba(212, 175, 55, 0.6))';
    });

    logoImage.addEventListener('mouseleave', function() {
      this.style.transform = '';
      this.style.filter = '';
    });
  }
}
