/**
 * ملف التحقق من تسجيل الدخول
 * يتحقق هذا الملف من حالة تسجيل الدخول ويوجه المستخدمين غير المسجلين إلى صفحة تسجيل الدخول
 */

// التحقق من حالة تسجيل الدخول عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
  checkLoginStatus();
});

/**
 * التحقق من حالة تسجيل الدخول
 * إذا لم يكن المستخدم مسجل الدخول، يتم توجيهه إلى صفحة تسجيل الدخول
 */
function checkLoginStatus() {
  // التحقق مما إذا كانت الصفحة الحالية هي صفحة تسجيل الدخول أو صفحة التسجيل
  const isLoginPage = window.location.pathname.includes('login.html');
  const isRegisterPage = window.location.pathname.includes('register.html');
  const isAuthPage = isLoginPage || isRegisterPage;

  // الحصول على حالة تسجيل الدخول من localStorage
  const isLoggedIn = localStorage.getItem('loggedIn') === 'true';

  // إذا لم يكن المستخدم مسجل الدخول ولم يكن في صفحة تسجيل الدخول أو صفحة التسجيل، يتم توجيهه إلى صفحة تسجيل الدخول
  if (!isLoggedIn && !isAuthPage) {
    window.location.href = 'login.html';
    return;
  }

  // إذا كان المستخدم مسجل الدخول وكان في صفحة تسجيل الدخول أو صفحة التسجيل، يتم توجيهه إلى الصفحة الرئيسية
  if (isLoggedIn && isAuthPage) {
    window.location.href = 'index.html';
    return;
  }

  // إذا كان المستخدم مسجل الدخول، يتم تحديث معلومات المستخدم في القائمة الجانبية
  if (isLoggedIn) {
    updateUserInfo();
  }
}

/**
 * تحديث معلومات المستخدم في القائمة الجانبية
 */
function updateUserInfo() {
  // الحصول على معلومات المستخدم من localStorage
  const username = localStorage.getItem('username') || 'مدير النظام';
  const userEmail = localStorage.getItem('userEmail') || 'admin@example.com';
  const fullName = localStorage.getItem('fullName');

  // البحث عن عناصر معلومات المستخدم في القائمة الجانبية
  const userNameElement = document.querySelector('.sidebar .user-name');
  const userEmailElement = document.querySelector('.sidebar .user-email');

  // تحديث معلومات المستخدم إذا وجدت العناصر
  if (userNameElement) {
    // استخدام الاسم الكامل إذا كان متاحًا، وإلا استخدام اسم المستخدم
    userNameElement.textContent = fullName || username;
  }

  if (userEmailElement) {
    userEmailElement.textContent = userEmail;
  }

  // تحديث أي عناصر أخرى تعرض معلومات المستخدم في الصفحة
  const userDisplayElements = document.querySelectorAll('.user-display-name');
  if (userDisplayElements.length > 0) {
    userDisplayElements.forEach(element => {
      element.textContent = fullName || username;
    });
  }
}

/**
 * تسجيل الخروج
 * يقوم بحذف معلومات تسجيل الدخول من localStorage وتوجيه المستخدم إلى صفحة تسجيل الدخول
 */
function logout() {
  // حذف معلومات تسجيل الدخول من localStorage
  localStorage.removeItem('loggedIn');
  localStorage.removeItem('username');
  localStorage.removeItem('userEmail');
  localStorage.removeItem('fullName');

  // عرض رسالة تأكيد
  if (confirm('هل أنت متأكد من رغبتك في تسجيل الخروج؟')) {
    // توجيه المستخدم إلى صفحة تسجيل الدخول
    window.location.href = 'login.html';
  }
}

// إضافة مستمع حدث لزر تسجيل الخروج
document.addEventListener('DOMContentLoaded', function() {
  const logoutButton = document.querySelector('.sidebar .logout-button');

  if (logoutButton) {
    logoutButton.addEventListener('click', logout);
  }
});
