<?php
// تضمين ملف التكوين
require_once '../config/config.php';

// التحقق من تسجيل الدخول
if (!isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'غير مصرح لك بالوصول'
    ]);
    exit;
}

// التحقق من أن الطلب هو طلب POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'يجب استخدام طريقة POST'
    ]);
    exit;
}

// الحصول على بيانات الطلب
$data = json_decode(file_get_contents('php://input'), true);

// التحقق من وجود معرف الطلب
if (!isset($data['id']) || empty($data['id'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'معرف الطلب مطلوب'
    ]);
    exit;
}

// الحصول على معرف الطلب
$orderId = (int)$data['id'];

// الحصول على معلومات المستخدم الحالي
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$currentUser = $stmt->fetch();

// التحقق من صلاحيات المستخدم
$canEditOrder = ($currentUser['role'] === 'admin' || $currentUser['role'] === 'manager');

if (!$canEditOrder) {
    // التحقق مما إذا كان الطلب ينتمي للمستخدم الحالي
    $stmt = $pdo->prepare("SELECT user_id FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order || $order['user_id'] != $_SESSION['user_id']) {
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => 'ليس لديك صلاحية لتعديل هذا الطلب'
        ]);
        exit;
    }
}

// التحقق من البيانات المطلوبة
$requiredFields = ['clientName', 'serviceType', 'goodsName', 'goodsType', 'deliveryArea'];
foreach ($requiredFields as $field) {
    if (!isset($data[$field]) || empty($data[$field])) {
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => 'جميع الحقول المطلوبة يجب ملؤها'
        ]);
        exit;
    }
}

try {
    // بدء المعاملة
    $pdo->beginTransaction();
    
    // تحديد معرف الفرع
    $branchId = null;
    if (isset($data['branch']) && !empty($data['branch'])) {
        $stmt = $pdo->prepare("SELECT id FROM branches WHERE name = ?");
        $stmt->execute([$data['branch']]);
        $branch = $stmt->fetch();
        if ($branch) {
            $branchId = $branch['id'];
        }
    }
    
    // تحديد حالة الدفع
    $paymentStatus = 'غير مدفوع';
    if (isset($data['amountPaid']) && isset($data['clientAmount'])) {
        if ($data['amountPaid'] >= $data['clientAmount']) {
            $paymentStatus = 'مدفوع';
        } elseif ($data['amountPaid'] > 0) {
            $paymentStatus = 'جزئي';
        }
    }
    
    // تحديث الطلب
    $stmt = $pdo->prepare("
        UPDATE orders SET
            client_name = ?,
            service_type = ?,
            branch_id = ?,
            departure_area = ?,
            second_destination = ?,
            delivery_area = ?,
            goods_name = ?,
            goods_type = ?,
            country_of_origin = ?,
            weight = ?,
            delivery_duration = ?,
            order_upload_date = ?,
            scheduled_delivery_date = ?,
            recipient_name = ?,
            phone_number = ?,
            service_fees = ?,
            currency = ?,
            amount_agreed_with_customer = ?,
            amount_agreed_with_agent = ?,
            amount_paid = ?,
            remaining_amount = ?,
            other_expenses = ?,
            profit = ?,
            employee_name = ?,
            status = ?,
            payment_status = ?,
            notes = ?,
            updated_at = NOW()
        WHERE id = ?
    ");
    
    $stmt->execute([
        $data['clientName'],
        $data['serviceType'],
        $branchId,
        $data['departureArea'] ?? null,
        $data['secondDestination'] ?? null,
        $data['deliveryArea'],
        $data['goodsName'],
        $data['goodsType'],
        $data['countryOfOrigin'] ?? null,
        $data['weight'] ?? null,
        $data['deliveryDuration'] ?? null,
        $data['orderDate'] ?? null,
        $data['expectedDeliveryDate'] ?? null,
        $data['receiverName'] ?? null,
        $data['phoneNumber'] ?? null,
        $data['serviceFee'] ?? null,
        $data['currency'] ?? null,
        $data['clientAmount'] ?? null,
        $data['agentAmount'] ?? null,
        $data['amountPaid'] ?? null,
        $data['remainingAmount'] ?? null,
        $data['otherExpenses'] ?? null,
        $data['profit'] ?? null,
        $data['responsibleEmployee'] ?? null,
        $data['orderStatus'] ?? 'قيد المعالجة',
        $paymentStatus,
        $data['notes'] ?? null,
        $orderId
    ]);
    
    // التحقق من نجاح التحديث
    if ($stmt->rowCount() === 0) {
        throw new Exception('لم يتم العثور على الطلب أو لم يتم إجراء أي تغييرات');
    }
    
    // تأكيد المعاملة
    $pdo->commit();
    
    // إرجاع رسالة نجاح
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'message' => 'تم تحديث الطلب بنجاح',
        'order_id' => $orderId
    ]);
} catch (Exception $e) {
    // التراجع عن المعاملة في حالة حدوث خطأ
    $pdo->rollBack();
    
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'فشل في تحديث الطلب: ' . $e->getMessage()
    ]);
}
