<?php
/**
 * ملف إعادة تعيين أرقام الطلبات
 * يستخدم هذا الملف لإعادة تعيين أرقام الطلبات التسلسلية لجميع الفروع
 */

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// التحقق من أن الطلب هو طلب GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'يجب استخدام طريقة GET']);
    exit;
}

try {
    // إعادة تعيين أرقام الطلبات التسلسلية لجميع الفروع
    $stmt = $conn->prepare("UPDATE order_sequences SET last_sequence_number = 0");
    $stmt->execute();
    
    // التحقق من عدد الصفوف المتأثرة
    $rowCount = $stmt->rowCount();
    
    // إرجاع استجابة نجاح
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'message' => 'تم إعادة تعيين أرقام الطلبات بنجاح',
        'affected_rows' => $rowCount
    ]);
    
} catch (PDOException $e) {
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'فشل في إعادة تعيين أرقام الطلبات: ' . $e->getMessage()
    ]);
}
?>
