<?php
// معلومات الاتصال بقاعدة البيانات
$host = 'localhost';
$dbname = 'shipping_system';
$username = 'root'; // قم بتغيير هذا إلى اسم المستخدم الخاص بك
$password = ''; // قم بتغيير هذا إلى كلمة المرور الخاصة بك

// إنشاء اتصال PDO
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    // ضبط وضع الخطأ إلى استثناء
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // ضبط الوضع الافتراضي لجلب البيانات
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    // تعطيل محاكاة الاستعلامات المعدة
    $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
} catch (PDOException $e) {
    // في حالة فشل الاتصال
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

// دالة للحصول على رقم طلب جديد
function getNewOrderNumber($pdo, $branchCode) {
    try {
        // البحث عن آخر رقم تسلسلي للفرع
        $stmt = $pdo->prepare("SELECT last_sequence_number FROM order_sequences WHERE branch_code = ?");
        $stmt->execute([$branchCode]);
        $result = $stmt->fetch();

        // الحصول على السنة الحالية (آخر رقمين)
        $year = date('y');

        if ($result) {
            $lastNumber = $result['last_sequence_number'];
            $newNumber = $lastNumber + 1;

            // تحديث الرقم التسلسلي في قاعدة البيانات
            $updateStmt = $pdo->prepare("UPDATE order_sequences SET last_sequence_number = ? WHERE branch_code = ?");
            $updateStmt->execute([$newNumber, $branchCode]);

            // تنسيق الرقم التسلسلي
            $sequenceNumber = str_pad($newNumber, 2, '0', STR_PAD_LEFT);

            // إنشاء رقم الطلب الكامل
            $newOrderNumber = $branchCode . $year . '-' . $sequenceNumber;

            return $newOrderNumber;
        } else {
            // إذا لم يتم العثور على رمز الفرع، قم بإنشاء سجل جديد
            $insertStmt = $pdo->prepare("INSERT INTO order_sequences (branch_code, last_sequence_number) VALUES (?, 1)");
            $insertStmt->execute([$branchCode]);

            return $branchCode . $year . '-01';
        }
    } catch (PDOException $e) {
        // في حالة حدوث خطأ
        return false;
    }
}

// دالة لتحويل التاريخ من التنسيق العربي إلى تنسيق قاعدة البيانات
function convertDateToMysql($date) {
    if (empty($date)) return null;

    // تحويل التاريخ من التنسيق العربي (DD/MM/YYYY) إلى تنسيق MySQL (YYYY-MM-DD)
    $parts = explode('/', $date);
    if (count($parts) === 3) {
        return $parts[2] . '-' . $parts[1] . '-' . $parts[0];
    }

    return $date;
}

// دالة لتحويل التاريخ من تنسيق قاعدة البيانات إلى التنسيق العربي
function convertDateToArabic($date) {
    if (empty($date)) return '';

    // تحويل التاريخ من تنسيق MySQL (YYYY-MM-DD) إلى التنسيق العربي (DD/MM/YYYY)
    $parts = explode('-', $date);
    if (count($parts) === 3) {
        return $parts[2] . '/' . $parts[1] . '/' . $parts[0];
    }

    return $date;
}
?>