<?php
/**
 * API لتعيين جميع الإشعارات كمقروءة
 */

// بدء الجلسة
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'غير مصرح به']);
    exit;
}

// الحصول على اتصال قاعدة البيانات
require_once __DIR__ . '/../config/db_connection.php';

// الحصول على معرف المستخدم الحالي
$userId = $_SESSION['user_id'];

try {
    // تحديث جميع الإشعارات غير المقروءة للمستخدم
    $stmt = $pdo->prepare("
        UPDATE `notifications`
        SET is_read = 1
        WHERE (user_id = ? OR user_id IS NULL)
        AND is_read = 0
    ");
    
    $success = $stmt->execute([$userId]);
    
    // إرجاع النتيجة
    header('Content-Type: application/json');
    echo json_encode(['success' => $success]);
} catch (PDOException $e) {
    // تسجيل الخطأ
    error_log("خطأ في تعيين جميع الإشعارات كمقروءة: " . $e->getMessage());
    
    // إرجاع رسالة خطأ
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'حدث خطأ أثناء تحديث الإشعارات']);
}
