<?php
/**
 * إنشاء جدول سجل النشاط (activity_log) إذا لم يكن موجوداً
 */

// بدء الجلسة
session_start();

// التحقق من تسجيل دخول المستخدم
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'يجب تسجيل الدخول للوصول إلى هذه البيانات'
    ]);
    exit;
}

// التحقق من صلاحيات المستخدم (مسموح فقط للمدير)
if ($_SESSION['role'] !== 'admin') {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'ليس لديك صلاحية الوصول إلى هذه البيانات'
    ]);
    exit;
}

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

try {
    // التحقق من وجود جدول سجل النشاط
    $stmt = $conn->prepare("SHOW TABLES LIKE 'activity_log'");
    $stmt->execute();
    $tableExists = $stmt->rowCount() > 0;

    if (!$tableExists) {
        // إنشاء جدول سجل النشاط
        $sql = "
            CREATE TABLE activity_log (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id INT NOT NULL,
                action VARCHAR(50) NOT NULL,
                target_id INT,
                target_type VARCHAR(50),
                details TEXT,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                INDEX (user_id),
                INDEX (action),
                INDEX (target_id, target_type)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ";
        $conn->exec($sql);

        // إرجاع استجابة النجاح
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success',
            'message' => 'تم إنشاء جدول سجل النشاط بنجاح'
        ]);
    } else {
        // الجدول موجود بالفعل
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success',
            'message' => 'جدول سجل النشاط موجود بالفعل'
        ]);
    }
} catch (PDOException $e) {
    // تسجيل الخطأ
    error_log('خطأ في قاعدة البيانات: ' . $e->getMessage());
    
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'حدث خطأ أثناء إنشاء جدول سجل النشاط: ' . $e->getMessage()
    ]);
}
?>
