<?php
/**
 * ملف API للتحقق من الفرع المخصص للمستخدم
 * يستخدم هذا الملف للتحقق من الفرع المخصص للمستخدم بناءً على البريد الإلكتروني
 */

// تعيين نوع المحتوى
header('Content-Type: application/json; charset=utf-8');

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// التحقق من طريقة الطلب
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode([
        'success' => false,
        'message' => 'طريقة الطلب غير صالحة. يجب استخدام طريقة GET.'
    ]);
    exit;
}

// الحصول على البريد الإلكتروني من الطلب
$email = isset($_GET['email']) ? trim($_GET['email']) : '';

// التحقق من وجود البريد الإلكتروني
if (empty($email)) {
    echo json_encode([
        'success' => false,
        'message' => 'البريد الإلكتروني مطلوب.'
    ]);
    exit;
}

try {
    // البحث عن المستخدم والفرع المخصص له
    $stmt = $conn->prepare("
        SELECT u.id, u.branch_id, b.name AS branch_name, b.code AS branch_code
        FROM users u
        LEFT JOIN branches b ON u.branch_id = b.id
        WHERE u.email = :email AND u.status = 'active'
    ");
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // التحقق من وجود المستخدم
    if (!$user) {
        echo json_encode([
            'success' => false,
            'message' => 'لم يتم العثور على مستخدم بهذا البريد الإلكتروني.'
        ]);
        exit;
    }
    
    // التحقق من وجود فرع مخصص للمستخدم
    if (empty($user['branch_id'])) {
        echo json_encode([
            'success' => true,
            'message' => 'المستخدم ليس لديه فرع مخصص.',
            'branch_id' => null,
            'branch_name' => null,
            'branch_code' => null
        ]);
        exit;
    }
    
    // إرجاع معلومات الفرع المخصص للمستخدم
    echo json_encode([
        'success' => true,
        'message' => 'تم العثور على الفرع المخصص للمستخدم.',
        'branch_id' => $user['branch_id'],
        'branch_name' => $user['branch_name'],
        'branch_code' => $user['branch_code']
    ]);
} catch (PDOException $e) {
    // تسجيل الخطأ
    error_log('خطأ في التحقق من الفرع المخصص للمستخدم: ' . $e->getMessage());
    
    // إرجاع رسالة خطأ
    echo json_encode([
        'success' => false,
        'message' => 'حدث خطأ أثناء التحقق من الفرع المخصص للمستخدم.'
    ]);
}
?>
