<?php
// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/db_connection.php';

// التحقق من أن الطلب هو طلب GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'يجب استخدام طريقة GET']);
    exit;
}

try {
    // جلب جميع الفروع
    $stmt = $conn->prepare("SELECT id, name, code, address, phone FROM branches ORDER BY name");
    $stmt->execute();
    $branches = $stmt->fetchAll();

    // إرجاع الفروع
    header('Content-Type: application/json');
    echo json_encode(['status' => 'success', 'branches' => $branches]);

} catch (PDOException $e) {
    // إرجاع رسالة الخطأ
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'فشل جلب الفروع: ' . $e->getMessage()]);
}
?>
