# مجلد API

هذا المجلد يحتوي على ملفات API الخاصة بنظام طلبات الشحن. تستخدم هذه الملفات لتوفير واجهة برمجة تطبيقات للتفاعل مع قاعدة البيانات وتنفيذ العمليات المختلفة.

## الملفات الرئيسية

- **branches.php**: API للتعامل مع الفروع (إضافة، تعديل، حذف، استعلام)
- **orders.php**: API للتعامل مع الطلبات (إنشاء، تحديث، حذف، استعلام)
- **users.php**: API للتعامل مع المستخدمين (تسجيل، تحديث، حذف، استعلام)
- **auth.php**: API للمصادقة وإدارة الجلسات
- **settings.php**: API لإعدادات النظام

## كيفية الاستخدام

يتم استدعاء هذه الملفات من خلال طلبات AJAX من الواجهة الأمامية. تستخدم الطلبات طريقة POST وتتوقع البيانات بتنسيق JSON.

### مثال على استدعاء API

```javascript
// مثال على إنشاء طلب جديد
fetch('api/orders.php', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
  },
  body: JSON.stringify({
    action: 'create',
    data: {
      // بيانات الطلب
    }
  })
})
.then(response => response.json())
.then(data => {
  // معالجة الاستجابة
})
.catch(error => {
  // معالجة الخطأ
});
```

## هيكل الاستجابة

تعيد جميع نقاط نهاية API استجابة بتنسيق JSON بالهيكل التالي:

```json
{
  "status": "success|error",
  "message": "رسالة توضيحية",
  "data": {
    // البيانات المطلوبة (إن وجدت)
  }
}
```

## الأمان

- يتم التحقق من المصادقة لجميع طلبات API باستثناء طلبات تسجيل الدخول
- يتم التحقق من صلاحيات المستخدم قبل تنفيذ أي عملية
- يتم تنظيف وتحقق من جميع المدخلات لمنع هجمات حقن SQL وهجمات XSS
