<?php
/**
 * ملف AJAX للحصول على بيانات الدور
 * 
 * @version 1.0
 * @author System Developer
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/database.php';

// تضمين ملفات إدارة الإعدادات والصلاحيات
require_once '../includes/settings_manager.php';
require_once '../includes/permissions_manager.php';

// التحقق من وجود معرف الدور
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'معرف الدور غير صالح'
    ]);
    exit;
}

$roleId = (int)$_GET['id'];

try {
    // الحصول على بيانات الدور
    $stmt = $pdo->prepare("SELECT * FROM roles WHERE id = :id");
    $stmt->execute(['id' => $roleId]);
    $role = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$role) {
        echo json_encode([
            'status' => 'error',
            'message' => 'الدور غير موجود'
        ]);
        exit;
    }
    
    // الحصول على صلاحيات الدور
    $stmt = $pdo->prepare("
        SELECT permission_id 
        FROM role_permissions 
        WHERE role_id = :role_id
    ");
    $stmt->execute(['role_id' => $roleId]);
    $rolePermissions = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // إرجاع البيانات
    echo json_encode([
        'status' => 'success',
        'role' => $role,
        'role_permissions' => $rolePermissions
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'حدث خطأ أثناء الحصول على بيانات الدور: ' . $e->getMessage()
    ]);
}
?>
