<?php
/**
 * ملف AJAX للحصول على بيانات الصلاحية
 * 
 * @version 1.0
 * @author System Developer
 */

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تضمين ملف الاتصال بقاعدة البيانات
require_once '../config/database.php';

// تضمين ملفات إدارة الإعدادات والصلاحيات
require_once '../includes/settings_manager.php';
require_once '../includes/permissions_manager.php';

// التحقق من وجود معرف الصلاحية
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'معرف الصلاحية غير صالح'
    ]);
    exit;
}

$permissionId = (int)$_GET['id'];

try {
    // الحصول على بيانات الصلاحية
    $stmt = $pdo->prepare("SELECT * FROM permissions WHERE id = :id");
    $stmt->execute(['id' => $permissionId]);
    $permission = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$permission) {
        echo json_encode([
            'status' => 'error',
            'message' => 'الصلاحية غير موجودة'
        ]);
        exit;
    }
    
    // إرجاع البيانات
    echo json_encode([
        'status' => 'success',
        'permission' => $permission
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'حدث خطأ أثناء الحصول على بيانات الصلاحية: ' . $e->getMessage()
    ]);
}
?>
