# نظام طلبات الشحن - مجموعة ابراهيم الاحمدي اليمنية

نظام متكامل لإدارة طلبات الشحن والتوصيل لمجموعة ابراهيم الاحمدي اليمنية. يوفر النظام واجهة سهلة الاستخدام لإدارة الطلبات والعملاء والفروع والتقارير.

## هيكل المشروع

```
/
├── api/                  # واجهات برمجة التطبيقات
├── assets/               # الأصول الثابتة (الصور، الأيقونات، إلخ)
│   ├── css/              # ملفات CSS
│   ├── js/               # ملفات JavaScript
│   ├── images/           # الصور
│   └── fonts/            # الخطوط
├── auth/                 # ملفات المصادقة وإدارة المستخدمين
├── backups/              # النسخ الاحتياطية
├── config/               # ملفات التكوين
├── database/             # ملفات قاعدة البيانات
├── docs/                 # الوثائق والتعليمات
├── includes/             # مكونات PHP القابلة لإعادة الاستخدام
├── logs/                 # ملفات السجلات
├── orders/               # ملفات إدارة الطلبات
├── reports/              # ملفات التقارير
├── templates/            # قوالب HTML
├── uploads/              # ملفات التحميل
└── utils/                # أدوات وسكربتات مساعدة
```

## متطلبات النظام

- PHP 7.0 أو أحدث
- MySQL 5.7 أو أحدث
- خادم ويب (Apache أو Nginx)
- متصفح حديث يدعم JavaScript
- تفعيل امتدادات PHP: PDO, JSON, mbstring

## التثبيت

### التثبيت المحلي (XAMPP)

1. قم بتنزيل وتثبيت [XAMPP](https://www.apachefriends.org/download.html)
2. انسخ ملفات المشروع إلى مجلد `htdocs`
3. قم بإنشاء قاعدة بيانات جديدة باسم `shipping_db`
4. قم باستيراد ملف `database/unified_database_setup.sql` إلى قاعدة البيانات
5. قم بتعديل ملف `config/db_credentials.php` بمعلومات الاتصال بقاعدة البيانات
6. افتح المتصفح وانتقل إلى `http://localhost/ASDRF43/`

### التثبيت على استضافة cPanel

1. **تحضير الملفات**:
   - قم بتنظيف المشروع باستخدام `utils/cleanup_duplicates.php`
   - قم بتحسين أمان النظام باستخدام `utils/security_enhancer.php`
   - قم بالتحقق من جاهزية النظام للاستضافة باستخدام `utils/cpanel_readiness_check.php`

2. **تحميل الملفات**:
   - قم برفع جميع ملفات النظام إلى المجلد الرئيسي للاستضافة (public_html)
   - تأكد من رفع الملفات الخفية مثل `.htaccess`

3. **ضبط الصلاحيات**:
   - تأكد من ضبط صلاحيات الملفات إلى 644
   - تأكد من ضبط صلاحيات المجلدات إلى 755
   - تأكد من ضبط صلاحيات المجلدات التالية إلى 755: `uploads`, `logs`, `backups`, `cache`

4. **إعداد قاعدة البيانات**:
   - قم بإنشاء قاعدة بيانات جديدة على الاستضافة
   - قم بزيارة `database/setup_cpanel_database.php?token=ASDRF43_SECURE_TOKEN` لإعداد قاعدة البيانات

5. **اختبار النظام**:
   - انتقل إلى رابط موقعك
   - سجل الدخول باستخدام بيانات الدخول الافتراضية
   - قم بتغيير كلمة المرور الافتراضية فور تسجيل الدخول

للحصول على تعليمات مفصلة حول التثبيت على استضافة cPanel، يرجى الرجوع إلى ملف `docs/CPANEL_DEPLOYMENT_GUIDE.md`.

## الميزات الرئيسية

- إدارة الطلبات (إنشاء، تعديل، عرض، طباعة)
- تتبع حالة الطلبات وتحديثها
- إدارة المستخدمين والصلاحيات
- إدارة الفروع والإعدادات
- لوحة تحكم إحصائية موحدة
- تقارير أسبوعية وشهرية
- تصدير التقارير بصيغة PDF و Excel
- واجهة مستخدم سهلة الاستخدام
- دعم اللغة العربية بالكامل
- تصميم متجاوب يعمل على جميع الأجهزة

## ملفات مهمة للتحميل على الاستضافة

- `config/db_credentials.php` - ملف بيانات الاتصال بقاعدة البيانات (يجب تعديله حسب بيانات الاستضافة)
- `.htaccess` - ملف إعدادات Apache (يحتوي على قواعد إعادة التوجيه وإعدادات الأمان)
- `database/unified_database_setup.sql` - ملف قاعدة البيانات الموحد
- `database/setup_cpanel_database.php` - أداة إعداد قاعدة البيانات على cPanel
- `utils/cpanel_readiness_check.php` - أداة فحص جاهزية النظام للاستضافة على cPanel

## الأمان

تم تحسين أمان النظام من خلال:

- تشفير كلمات المرور باستخدام خوارزمية قوية
- حماية من هجمات SQL Injection باستخدام PDO و Prepared Statements
- حماية من هجمات XSS باستخدام تنظيف المدخلات
- حماية من هجمات CSRF باستخدام رموز CSRF
- تقييد الوصول إلى المجلدات والملفات الحساسة
- تسجيل النشاطات والأخطاء في ملفات السجلات
- إعدادات أمان محسنة في ملف .htaccess

## الصيانة الدورية

- قم بعمل نسخة احتياطية من قاعدة البيانات بشكل أسبوعي باستخدام phpMyAdmin في cPanel
- قم بمراجعة ملفات السجلات في مجلد `logs` بشكل دوري
- قم بتنظيف مجلد `cache` بشكل دوري
- قم بتشغيل `utils/security_enhancer.php` بشكل دوري لتحسين أمان النظام
- قم بتشغيل `utils/unused_code_detector.php` بشكل دوري للكشف عن الكود غير المستخدم
- قم بتحديث النظام عند توفر تحديثات جديدة

## استكشاف الأخطاء وإصلاحها

- إذا واجهت مشكلة في تسجيل الدخول، تأكد من صحة بيانات الدخول وتحقق من سجلات الخطأ
- إذا واجهت مشكلة في الاتصال بقاعدة البيانات، تأكد من صحة بيانات الاتصال في ملف `config/db_credentials.php`
- إذا واجهت مشكلة في عرض الصفحات، تأكد من توافق الاستضافة مع متطلبات النظام باستخدام `utils/cpanel_readiness_check.php`
- إذا واجهت مشكلة في تحميل الملفات، تأكد من صلاحيات مجلد `uploads`
- إذا واجهت مشكلة في الأمان، قم بتشغيل `utils/security_enhancer.php` لتحسين أمان النظام

## الدعم

للحصول على الدعم، يرجى التواصل مع:

- البريد الإلكتروني: ibrahim@al-ahmadigroup.com
- الهاتف: 05318281
- العنوان: اليمن، حضرموت، المكلا

## الترخيص

جميع الحقوق محفوظة لمجموعة ابراهيم الاحمدي اليمنية © 2025
