# تعليمات تشغيل نظام إدارة طلبات الشحن

## طريقة التشغيل السريعة

### 1. تشغيل الخادم المحلي

يمكنك تشغيل الخادم المحلي باستخدام PHP المدمج:

```
php -S 127.0.0.1:8000
```

أو باستخدام XAMPP:

1. قم بتشغيل XAMPP
2. قم بتشغيل خدمات Apache و MySQL
3. انسخ ملفات المشروع إلى مجلد `htdocs`
4. افتح المتصفح وانتقل إلى `http://localhost/ASDRF43`

### 2. إعداد قاعدة البيانات

1. قم بإنشاء قاعدة بيانات جديدة باسم `shipping_db`
2. قم باستيراد ملف `database/database.sql` إلى قاعدة البيانات
3. قم بتعديل ملف `config/db_connection.php` بمعلومات الاتصال بقاعدة البيانات

### 3. تسجيل الدخول

- اسم المستخدم: `admin`
- كلمة المرور: `admin123`

## هيكل المشروع

```
/
├── admin/                # ملفات لوحة التحكم والإدارة
├── api/                  # واجهات برمجة التطبيقات
├── assets/               # الأصول الثابتة (الصور، الأيقونات، إلخ)
│   ├── css/              # ملفات CSS
│   ├── js/               # ملفات JavaScript
│   ├── images/           # الصور
│   └── fonts/            # الخطوط
├── auth/                 # ملفات المصادقة وإدارة المستخدمين
├── config/               # ملفات التكوين
├── core/                 # الملفات الأساسية للنظام
├── database/             # ملفات قاعدة البيانات
├── docs/                 # الوثائق والتعليمات
├── includes/             # مكونات PHP القابلة لإعادة الاستخدام
├── orders/               # ملفات إدارة الطلبات
├── pages/                # صفحات HTML
├── setup/                # ملفات الإعداد والتثبيت
├── templates/            # قوالب HTML
├── tools/                # أدوات مساعدة وسكربتات
└── utils/                # أدوات وسكربتات مساعدة
```

## الملفات الرئيسية

- **index.php**: نقطة الدخول الرئيسية للتطبيق
- **core/config.php**: ملف التكوين الرئيسي
- **core/security.php**: ملف تكوين الأمان
- **auth/auth.php**: ملف المصادقة وإدارة المستخدمين
- **includes/functions.php**: ملف الدوال المساعدة
- **database/database.sql**: ملف قاعدة البيانات

## استكشاف الأخطاء وإصلاحها

### مشكلة: لا يمكن الاتصال بقاعدة البيانات

1. تأكد من تشغيل خدمة MySQL
2. تأكد من صحة معلومات الاتصال في ملف `config/db_connection.php`
3. تأكد من وجود قاعدة البيانات `shipping_db`

### مشكلة: صفحة فارغة أو خطأ 500

1. تأكد من تفعيل عرض الأخطاء في PHP
2. تحقق من سجلات الخطأ في PHP
3. تأكد من وجود جميع الملفات المطلوبة

### مشكلة: لا يمكن تسجيل الدخول

1. تأكد من وجود جدول المستخدمين في قاعدة البيانات
2. تأكد من وجود مستخدم `admin` في قاعدة البيانات
3. تأكد من صحة كلمة المرور

## الخطوات التالية

1. إكمال إعداد قاعدة البيانات
2. تطوير وظائف النظام المختلفة
3. اختبار النظام بشكل شامل
4. نشر النظام على بيئة الإنتاج
